/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.client;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.IntConsumer;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import snownee.kiwi.KiwiClientConfig;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.item.ModItem;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.util.KUtil;

public final class TooltipEvents {
    public static final String disableDebugTooltipCommand = "@kiwi disable debugTooltip";
    private static final DebugTooltipCache cache = new DebugTooltipCache();
    private static boolean firstSeenDebugTooltip = true;
    private static long latestPressF3;
    private static boolean holdAlt;
    private static long holdAltStart;
    private static boolean showTagsBeforeAlt;

    private TooltipEvents() {
    }

    public static void globalTooltip(ItemStack stack, List<Component> tooltip, TooltipFlag flag) {
        if (KiwiClientConfig.globalTooltip) {
            ModItem.addTip(stack, tooltip, flag);
        }
    }

    public static void debugTooltip(ItemStack itemStack, List<Component> tooltip, TooltipFlag flag) {
        if (!flag.isAdvanced()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        long millis = Util.getMillis();
        if (KiwiClientConfig.f3CopyInInventory && mc.player != null && millis - latestPressF3 > 500L && InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)292)) {
            latestPressF3 = millis;
            MutableComponent component = Component.literal((String)BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).toString());
            mc.keyboardHandler.setClipboard(component.getString());
            mc.player.displayClientMessage((Component)KUtil.clickToCopy(component), false);
        }
        if (KiwiClientConfig.hideDataComponentsTooltip) {
            tooltip.removeIf(c -> c.getContents() instanceof TranslatableContents && "item.components".equals(((TranslatableContents)c.getContents()).getKey()));
        }
        if (KiwiClientConfig.tagsTooltip) {
            cache.maybeUpdateTags(itemStack);
            boolean alt = Screen.hasAltDown();
            if (!holdAlt && alt) {
                holdAltStart = millis;
                showTagsBeforeAlt = TooltipEvents.cache.showTags;
            } else if (holdAlt && !alt && TooltipEvents.cache.showTags && millis - holdAltStart < 500L) {
                TooltipEvents.cache.pageNow = TooltipEvents.cache.pageNow + (Screen.hasControlDown() ? -1 : 1);
                TooltipEvents.cache.needUpdatePreferredType = true;
            }
            if (alt && millis - holdAltStart >= 500L) {
                TooltipEvents.cache.showTags = !showTagsBeforeAlt;
                TooltipEvents.cache.lastShowTags = millis;
            }
            holdAlt = alt;
            if (!TooltipEvents.cache.pages.isEmpty()) {
                TooltipEvents.trySendTipMsg(mc);
                cache.appendTagsTooltip(tooltip);
            }
        }
    }

    private static void trySendTipMsg(Minecraft mc) {
        if (firstSeenDebugTooltip && mc.player != null) {
            firstSeenDebugTooltip = false;
            if (KiwiClientConfig.debugTooltipMsg) {
                MutableComponent clickHere = Component.translatable((String)"tip.kiwi.click_here").withStyle($ -> $.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, disableDebugTooltipCommand)));
                mc.player.sendSystemMessage((Component)Component.translatable((String)"tip.kiwi.debug_tooltip", (Object[])new Object[]{clickHere.withStyle(ChatFormatting.AQUA)}));
                KiwiClientConfig.debugTooltipMsg = false;
                KiwiConfigManager.getHandler(KiwiClientConfig.class).save();
            }
        }
    }

    private static class DebugTooltipCache {
        private final List<String> pageTypes = Lists.newArrayList();
        private final List<List<String>> pages = Lists.newArrayList();
        private final List<List<String>> translatedPages = Lists.newArrayList();
        private int pageNow = 0;
        private ItemStack itemStack = ItemStack.EMPTY;
        private boolean showTags;
        private long lastShowTags;
        private String preferredType;
        public boolean needUpdatePreferredType;

        private DebugTooltipCache() {
        }

        public void maybeUpdateTags(ItemStack itemStack) {
            if (this.itemStack == itemStack) {
                return;
            }
            this.itemStack = itemStack;
            this.pages.clear();
            this.translatedPages.clear();
            this.pageTypes.clear();
            this.pageNow = 0;
            this.addPages("item", itemStack.getTags());
            Item item = itemStack.getItem();
            Block block = Block.byItem((Item)item);
            if (block != Blocks.AIR) {
                this.addPages("block", DebugTooltipCache.getTags(BuiltInRegistries.BLOCK, block));
            }
            if (item instanceof SpawnEggItem) {
                SpawnEggItem spawnEggItem = (SpawnEggItem)item;
                EntityType type = spawnEggItem.getType(itemStack);
                this.addPages("entity_type", DebugTooltipCache.getTags(BuiltInRegistries.ENTITY_TYPE, type));
            } else if (item instanceof BucketItem) {
                BucketItem bucketItem = (BucketItem)item;
                this.addPages("fluid", DebugTooltipCache.getTags(BuiltInRegistries.FLUID, Platform.getFluidFromBucket(bucketItem)));
            }
            for (int i = 0; i < this.pages.size(); ++i) {
                if (!this.pageTypes.get(i).equals(this.preferredType)) continue;
                this.pageNow = i;
                break;
            }
        }

        private static <T> Stream<TagKey<T>> getTags(Registry<T> registry, T object) {
            return registry.getResourceKey(object).flatMap(arg_0 -> registry.getHolder(arg_0)).stream().flatMap(Holder::tags);
        }

        public void addPages(String type, Stream<? extends TagKey<?>> stream) {
            List<TagKey> tags = stream.sorted(Comparator.comparing($ -> $.location())).toList();
            if (tags.isEmpty()) {
                return;
            }
            int i = 0;
            ArrayList page = Lists.newArrayList();
            ArrayList translatedPage = Lists.newArrayList();
            for (TagKey tag : tags) {
                page.add("#" + String.valueOf(tag.location()));
                String translationKey = Platform.getTagTranslationKey(tag);
                if (I18n.exists((String)translationKey)) {
                    translatedPage.add("#" + I18n.get((String)translationKey, (Object[])new Object[0]));
                } else {
                    translatedPage.add("#" + String.valueOf(tag.location()));
                }
                if (++i != KiwiClientConfig.tagsTooltipTagsPerPage) continue;
                this.pages.add(page);
                this.translatedPages.add(translatedPage);
                this.pageTypes.add(type);
                page = Lists.newArrayList();
                translatedPage = Lists.newArrayList();
                i = 0;
            }
            if (!page.isEmpty()) {
                this.pages.add(page);
                this.translatedPages.add(translatedPage);
                this.pageTypes.add(type);
            }
        }

        public void appendTagsTooltip(List<Component> tooltip) {
            boolean showTranslatedTags;
            if (this.pages.isEmpty()) {
                return;
            }
            if (this.showTags && Util.getMillis() - this.lastShowTags > 60000L) {
                this.showTags = false;
            }
            if (!this.showTags) {
                if (KiwiClientConfig.tagsTooltipAppendKeybindHint) {
                    this.findIdLine(tooltip, i -> tooltip.set(i, (Component)((Component)tooltip.get(i)).copy().append(" (alt)")));
                }
                return;
            }
            this.lastShowTags = Util.getMillis();
            ArrayList sub = Lists.newArrayList();
            this.pageNow = Math.floorMod(this.pageNow, this.pages.size());
            if (this.needUpdatePreferredType) {
                this.needUpdatePreferredType = false;
                this.preferredType = this.pageTypes.get(this.pageNow);
            }
            List<String> page = (showTranslatedTags = KiwiClientConfig.showTranslatedTagsByDefault ^ Screen.hasControlDown()) ? this.translatedPages.get(this.pageNow) : this.pages.get(this.pageNow);
            for (String tag : page) {
                sub.add(Component.literal((String)tag).withStyle(ChatFormatting.DARK_GRAY));
            }
            int index = this.findIdLine(tooltip, i -> {
                String type = this.pageTypes.get(this.pageNow);
                tooltip.set(i, (Component)((Component)tooltip.get(i)).copy().append(" (%s/%s...%s)".formatted(this.pageNow + 1, this.pages.size(), type)));
            });
            index = index == -1 ? tooltip.size() : index + 1;
            tooltip.addAll(index, sub);
        }

        private int findIdLine(List<Component> tooltip, IntConsumer consumer) {
            String id = BuiltInRegistries.ITEM.getKey((Object)this.itemStack.getItem()).toString();
            for (int i = 0; i < tooltip.size(); ++i) {
                Component component = tooltip.get(i);
                if (!component.getString().equals(id)) continue;
                consumer.accept(i);
                return i;
            }
            return -1;
        }
    }
}

